//---------------------------------------------------------------------------------------
//  FILE:    X2AbilityMultiTarget_Radius_LEBPsi
//  AUTHOR:  LeaderEnemyBoss
//  PURPOSE: Custom radius targeting style, allows for dynamic radius based on Caster's Will
//--------------------------------------------------------------------------------------- 

class X2AbilityMultiTarget_Radius_RMPsi extends X2AbilityMultiTarget_Radius;

var float PsiMulti;
var float MinRadius;
var float MaxRadius;

simulated function float GetTargetRadius(const XComGameState_Ability Ability)
{
	local float Radius, WillMod;
	local XComGameState_Unit SourceUnit;
	local int WillDiff;
	
	Radius = super.GetTargetRadius(Ability);

	SourceUnit = XComGameState_Unit(`XCOMHISTORY.GetGameStateForObjectID(Ability.OwnerStateObject.ObjectID));
	if(SourceUnit == none) return Radius;

	WillDiff = SourceUnit.GetCurrentStat(eStat_PsiOffense) - 100;
	WillMod = `XWORLD.WORLD_METERS_TO_UNITS_MULTIPLIER * (WillDiff * PsiMulti);
	Radius += WillMod;
	If (Radius < MinRadius*`XWORLD.WORLD_METERS_TO_UNITS_MULTIPLIER) Radius = MinRadius*`XWORLD.WORLD_METERS_TO_UNITS_MULTIPLIER;
	If (Radius > MaxRadius*`XWORLD.WORLD_METERS_TO_UNITS_MULTIPLIER) Radius = MaxRadius*`XWORLD.WORLD_METERS_TO_UNITS_MULTIPLIER;

	//`LEBMSG("SourceUnit:" @SourceUnit.GetFullName() @SourceUnit.GetCurrentStat(eStat_Will)@ ", Radius" @Radius);


	return Radius;
}

simulated function GetValidTilesForLocation(const XComGameState_Ability Ability, const vector Location, out array<TTile> ValidTiles)
{
	//local array<TTile> TempTiles;
	local array<TilePosPair> Tiles;
	local int i;

	`XWORLD.CollectTilesInSphere(Tiles, Location, GetTargetRadius(Ability));

	for (i = 0; i < Tiles.length; i++)
	{
		ValidTiles.AddItem(Tiles[i].Tile);
	}
}

simulated function GetMultiTargetsForLocation(XComGameState_Ability Ability, Vector Location, out AvailableTarget Target)
{
	local array<XComGameState_BaseObject> StateObjects;
	local XComGameState_BaseObject StateObject;

	GetTargetedStateObjects(Ability, Location, StateObjects);
	foreach StateObjects(StateObject)
	{
		if (Target.AdditionalTargets.Find('ObjectID', StateObject.ObjectID) == -1)
		{
			Target.AdditionalTargets.AddItem(StateObject.GetReference());
		}
	}
}

simulated function GetTargetedStateObjects(XComGameState_Ability Ability, Vector Location, out array<XComGameState_BaseObject> StateObjects)
{
	local XComGameStateHistory History;
	local XComWorldData WorldData;
	local array<TTile> ValidTiles;
	local TTile Tile;
	local array<StateObjectReference> UnitRefs;
	local StateObjectReference UnitRef;
	local XComGameState_BaseObject UseStateObject;

	History = `XCOMHISTORY;
	WorldData = `XWORLD;
	GetValidTilesForLocation(Ability, Location, ValidTiles);

	foreach ValidTiles(Tile)
	{
		// for now, skip destructible tiles for flamethrowers (for optimization), since they deal no environmental damage

		//check for units
		UnitRefs = WorldData.GetUnitsOnTile( Tile );
		foreach UnitRefs( UnitRef )
		{
			if (UnitRef.ObjectID > 0 && 
				!(bExcludeSelfAsTargetIfWithinRadius && (Ability.OwnerStateObject.ObjectID == UnitRef.ObjectID)))
			{
				UseStateObject = History.GetGameStateForObjectID(UnitRef.ObjectID);
				if (UseStateObject != none)
				{
					StateObjects.AddItem(UseStateObject);
				}
			}
		}


	}
	// skip bAllowDeadMultiTargetUnits check
}
